<%@ include file="validate_utf8.jsp" %>
<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="cn.sendsms.jdsmsserver.*"%>
<%
response.setHeader("Cache-Control","no-store");
response.setHeader("Pragrma","no-cache");
response.setDateHeader("Expires",0);
/*回调函数的一些设置,防止客户使用多个接口时出错*/

String callbackStatusVal="no";
String callbackInstanceIndex="";
String callbackInstanceName="";
Integer interfaceCount=0;
String[] foundedInterface;
String interfaceIndex;
Iterator<String> interfaceIterator = JDSMSServer.getInstance().getProperties().subset("interface").getKeys();

while(interfaceIterator.hasNext())
{
	interfaceIndex = (String) interfaceIterator.next();			//此方法自动列举interface.i的当前值
	if(Integer.toString(interfaceCount).equals(interfaceIndex)){
		//当interface的编号不连续的时候，interface无法启动，故作此判定
		//如果客户设置了不连续的接口号，这么做可以自动忽略客户自己设置的接口号，找到下一个连续的接口号
		interfaceCount++;
		try{
			foundedInterface=JDSMSServer.getInstance().getProperties().subset("interface").getStringArray(interfaceIndex);
		} catch (Exception ex) {
			JDSMSServer.getInstance().getService().getLogger().logError("Interface."+interfaceIndex+" in [JDSMSServer.conf] has been wrong configged",ex,null);
			break;
		}
		if(foundedInterface.length>1){							//确认 interface.i 是否填写完整，比如interface.2=httpServer2 没有填写是HttpServer还是其他方法,接口是无法启动的
			if(foundedInterface[1].equals("HttpPush"))			//确认 interface.i 是否为回调接口
			{
				callbackStatusVal="yes";
				callbackInstanceName=foundedInterface[0];		//方便识别客户自己写的接口，接口实例名称可以是任意值
				callbackInstanceIndex="interface." + interfaceIndex;
				break;
			}
		}else{
			JDSMSServer.getInstance().getService().getLogger().logWarn("interface."+interfaceIndex+" in [JDSMSServer.conf] doesn`t have interface method name, please set it carefully.\nFor Example：\ninterface."+interfaceIndex+" = X,Y \nX like http1 ,Y like HttpPush",null,null);
		}
	}else{
		JDSMSServer.getInstance().getService().getLogger().logError("interface."+interfaceIndex+" in [JDSMSServer.conf] is discontinuous to previous interfaces",null,null);
	}
}
if(callbackInstanceName.equals(""))					//如果上面寻找callback回调接口的循环中，没有任何一个结果是callback的接口，那就新建一个
{
	callbackInstanceName="http1";
	callbackInstanceIndex="interface." + Integer.toString(interfaceCount);
}

%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title><%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_setting")%></title>
<link href="css_serviceManager.css" type="text/css" rel="stylesheet">
</head>
<script type="text/javascript">

function submitto(url){
	document.all.settings.action = url;
	document.all.settings.submit();
}
function swi(obj){
	//alert(obj.checked);
	if(!obj.checked)
		obj.value="no";
	else obj.value="yes";
	//alert(obj.value);
}

function chooseIpOpt(obj){
	var val = obj.value;
	if(val == "0"){
		document.getElementById("ipAddr").value="";
		document.getElementById("subnet_mask").value="";
		document.getElementById("default_gateway").value="";
		document.getElementById("ipAddr").disabled = "disabled";
		document.getElementById("subnet_mask").disabled = "disabled";
		document.getElementById("default_gateway").disabled = "disabled";
		document.getElementById("ipfield").disabled = "disabled"; //锟斤拷锟斤拷disable锟斤拷锟斤拷
		document.getElementById("autoDNS").removeAttribute("disabled"); //锟狡筹拷disable锟斤拷锟斤拷
	}else if(val == "1"){
		document.getElementById("ipAddr").removeAttribute("disabled");
		document.getElementById("subnet_mask").removeAttribute("disabled");
		document.getElementById("default_gateway").removeAttribute("disabled");
		document.getElementById("ipfield").removeAttribute("disabled"); //锟狡筹拷disable锟斤拷锟斤拷

		document.getElementById("preferred_dns").removeAttribute("disabled");
		document.getElementById("alternate_dns").removeAttribute("disabled");
		document.getElementById("dnsfield").removeAttribute("disabled"); //锟狡筹拷disable锟斤拷锟斤拷
		document.getElementById("followedDNS").checked=true;
		document.getElementById("autoDNS").disabled = "disabled";
	}else if(val == "2"){
		document.getElementById("preferred_dns").value="";
		document.getElementById("alternate_dns").value="";
		document.getElementById("preferred_dns").disabled = "disabled";
		document.getElementById("alternate_dns").disabled = "disabled";
		document.getElementById("dnsfield").disabled = "disabled"; //锟斤拷锟斤拷disable锟斤拷锟斤拷
	}else if(val == "3"){
		document.getElementById("preferred_dns").removeAttribute("disabled");
		document.getElementById("alternate_dns").removeAttribute("disabled");
		document.getElementById("dnsfield").removeAttribute("disabled"); //锟狡筹拷disable锟斤拷锟斤拷
	}
}

function chooseSysInfoRadio(obj){
	var val = obj.value;
  if(val == "11"){
		document.getElementById("sys_info_ip_address").removeAttribute("disabled");
		document.getElementById("sys_info_ip_netmask").removeAttribute("disabled");
		document.getElementById("sys_info_ip_gateway").removeAttribute("disabled");
		document.getElementById("my_ip_field").removeAttribute("disabled");
		document.getElementById("sys_info_dns_address1").removeAttribute("disabled");
		document.getElementById("sys_info_dns_address2").removeAttribute("disabled");
		document.getElementById("my_dns_field").removeAttribute("disabled");
		document.getElementById("my_choose_dns").checked=true;
		document.getElementById("autoDNS").disabled = "disabled";
	}
}

function initPage(){
	var ipSet = document.getElementsByName("chooseip");
	var dnsSet = document.getElementsByName("chooseDNS");
  var sysInfoIpChooseSet = document.getElementsByName("sys_info_choose_ip");

	for(var i = 0; i < ipSet.length; i++){
		if(ipSet[i].checked){
			chooseIpOpt(ipSet[i])
		}
	}

	for(var j = 0; j < dnsSet.length; j++){
		if(dnsSet[j].checked){
			chooseIpOpt(dnsSet[j])
		}
	}

  for(var i = 0; i < sysInfoIpChooseSet.length; i++){
		if(sysInfoIpChooseSet[i].checked){
			chooseSysInfoRadio(sysInfoIpChooseSet[i])
		}
	}
}

function saveSysInfoIPConfig(){
	var myIpAddr     = document.getElementById("sys_info_ip_address").value;
	var mySubnetMask = document.getElementById("sys_info_ip_netmask").value;
	var myGateway    = document.getElementById("sys_info_ip_gateway").value;
	var myDns1       = document.getElementById("sys_info_dns_address1").value;
	var myDns2       = document.getElementById("sys_info_dns_address2").value;

	if(document.getElementById("my_choose_ip").checked){
		if(!isIP(myIpAddr)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_input_correct_ip")%>');
			return;
		}
		if(!isIP(mySubnetMask)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_subnet_mask")%>');
			return;
		}
		if(myGateway!="" && !isIP(myGateway)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_gateway_address")%>');
			return;
		}
	}
	if(document.getElementById("my_choose_dns").checked){
		if((myDns1 != "" && !isIP(myDns1)) ||
				(myDns2 != "" && !isIP(myDns2))){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_DNS_server_address")%>');
			return;
		}
	}
	document.sysInfoIpSetting.submit();
	alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reLogin")%>');

	window.top.location.href = "http://"+document.getElementById("sys_info_ip_address").value+":8090";
}

function saveIPConfig(){
	var ipAddr = document.getElementById("ipAddr").value;
	var subnet_mask = document.getElementById("subnet_mask").value;
	var default_gateway = document.getElementById("default_gateway").value;
	var preferred_dns = document.getElementById("preferred_dns").value;
	var alternate_dns = document.getElementById("alternate_dns").value;
	//锟斤拷锟絀P锟斤拷址锟较凤拷锟斤拷
	if(document.getElementById("followedip").checked){
		if(!isIP(ipAddr)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_input_correct_ip")%>');
			return;
		}
		if(!isIP(subnet_mask)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_subnet_mask")%>');
			return;
		}
		if(default_gateway!="" && !isIP(default_gateway)){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_gateway_address")%>');
			return;
		}
	}
	if(document.getElementById("followedDNS").checked){
		if((preferred_dns != "" && !isIP(preferred_dns)) ||
				(alternate_dns != "" && !isIP(alternate_dns))){
			alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_please_enter_the_correct_DNS_server_address")%>');
			return;
		}
	}
	document.ipSetting.submit();
	alert('<%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reLogin")%>');

	window.top.location.href = "http://"+document.getElementById("ipAddr").value+":8090";
}
function isIP(ip)
{
    var re =  /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/
    return re.test(ip);
}

window.onload = function(){
	//Auto calculation element id equal autoWidth width
	var edivright = top.window.main.window.document.getElementById("autoWidth");
	var hangW = edivright.parentNode.clientWidth - 185;
	edivright.style="width:"+hangW+"px";
}
var wb = document.getElementsByClassName("reset_btn");
setTimeout(function(){
	for(var i = 0;i<wb.length;i++){
		wb[i].addEventListener('click',function(obj){
			this.style="background:#FFF;border:1px solid #44a5a8;color:#5DB3B6;";
		});
	}
},500);


var text_success="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.message_success")%>";
var text_fail="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.message_failure")%>";
var text_welcome_message="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.home_welcome")%>";
var callback_timeout="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_callback_timeout")%>";

function callbackTester(){
	var callbackURL = document.getElementById("monback_geturl").value;
	callbackURL=callbackURL.replace("%gatewayId%","modem1");
	callbackURL=callbackURL.replace("%text%",encodeURI(text_welcome_message));
	callbackURL=callbackURL.replace("%originator%","127001");
	testURL(callbackURL);
}
function testURL(url){
	if (window.XMLHttpRequest)
		xmlhttp=new XMLHttpRequest();						//  IE7+, Firefox, Chrome, Opera, Safari 浏览器执行代码
	else
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");		// IE6, IE5 浏览器执行代码

	xmlhttp.open("GET",url,true);
	xmlhttp.send();
	ajaxTimeout = setTimeout(testURLFail, 5*1000);
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			clearTimeout(ajaxTimeout);
			alert(text_success);
			/*xmlhttp.status 怎么都不返回200..目前先这样*/
		}
	}
}
function testURLFail(){
	if (xmlhttp)
		xmlhttp.abort();
	alert(callback_timeout);
}
/*Callback用到的部分 -结束- */
</script>
<% if(JDSMSServer.getInstance().isWindows()) { %>
<body style="min-width: 1200px;">
<% }else { %>
<body onload="initPage()">
<% } %>
<style type="text/css">
	#top{
		color:#434343;
		font-size:22px;
		height:41px;
		padding:18px 0px 10px 0px;
		border-bottom:1px solid #fff;
		background:#dfe9ed;
		font-weight: normal;
		line-height: 35px;
	}
	#top span{padding-right:8px;float:left;margin-top:-12px;}
</style>
<div id="top"><span><img src="img/tu1.jpg"></span><%= ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_setting")%></div>
<style type="text/css">
	*{
		outline: none;
	}
	input[type='radio']{
		margin-right:5px;
		outline: none;
	}
	input[type='checkbox']{
		margin-right:5px;
		outline: none;
	}
	a:hover{
		text-decoration:none;
	}
	.sysset_line{
		width:100%;
		height:10px;
		margin:0 auto;
		border:none;
		border-bottom:1px solid #eaeaea;
		margin-bottom:5px;
	}
	.sysset_main{
		background: #fff;
		padding:0px 10px;
		padding-bottom:15px;
		width:96%;
		margin:0 auto;
		box-shadow: 0 1px 3px 0 rgba(223,223,223,0.50);
		max-width: 1320px;
	}
	.sysset_sub_title{
		border-bottom:1px solid #eaeaea;
		margin-bottom:10px;
		font-size: 16px;
		font-weight: bold;
		/*font-weight: 500;*/
	}
	.sysset_sub_title .title_sub{
		width:100% !important;
	}

	.sysset_main_left,.sysset_main_right{
		display: inline-block;
		float:left;
		width:48%;
		font-family: MicrosoftYaHei;
		color:#202020;
		font-size:14px;
	}
	.sysset_main_right{
		display: inline-block;
		float:right;
		width:48%;
		border:none;
		/*border-left:1px solid #d8d8d8;*/
	}
	.clear{
		clear:both;
	}
	.hang{
		margin-left:15px;
		padding:3px 0px;
	}
	.hang .left_col{
		display: inline-block;
		float:left;
		/*text-align: right;*/
		width:160px;
		margin-right:20px;
		line-height: 28px;
	}
	.sysset_sub_title .hang .left_col{
		text-align: left;
	}
	.hang .right_col{
		display: inline-block;
		float:left;
	}
	.hang .right_col input[type='text']{
		/*padding:0px 3px;*/
		outline: none;
		height:22px;
		line-height: 22px;
	}
	/* start - right cols width | three columns*/
	.hang .right_col.morecheckbox{
		width:340px;
	}
	.hang .right_col.morecheckbox label{
		display: inline-block;
		width:95px;
		padding-right:15px;
		margin-bottom:5px;
	}
	/* end - right cols width | three columns*/
	/* start - right cols width | two columns*/
	.hang .right_col.morecheckbox2{
		width:340px;
	}
	.hang .right_col.morecheckbox2 label{
		display: inline-block;
		width:150px;
		padding-right:15px;
		margin-bottom:5px;
	}
	/* end - right cols width | two columns*/

	.hang .right_col .label2{
		display: inline-block;
		width:140px;
	}
	.hang .right_col .label3{
		display: inline-block;
		width:80px;
	}

	.form_btn{
		/*width:340px;*/
		width:344px;
		margin:0 auto;
		border:none;
		margin-top:25px;
		margin-bottom:25px;
	}
	.submit_btn,.reset_btn{
        width:158px;
        height: 32px;
        line-height: 32px;
        border:1px solid #fff;
        background: #5DB3B6;
        border-radius: 5px;
        color:#fbfbfb;
        cursor: pointer;
	}
	.submit_btn:hover{
		background: #09999e;
	}
	.reset_btn:hover{
		background: #61cdd1;
		color:#fff;
	}
	.reset_btn{
		background: #fff;
		border:1px solid #5db3b6;
		color:#5DB3B6;
		margin-left:20px;
	}
	.line_u{
		width:1px;
		height:10px;
	}
	.callbackUrlText{
		width:100%;
		height:22px;
	}
	.callbackUrlText:focus{
		width:100%;
		height:80px;
		border:2px solid #09999e;
	}
	.callbackUrlTextLine{
		width:95%;
		height:22px;
	}

</style>
<div id="center" style="background: #fcfcfc;padding:27px 0px 0px 0px;">
	<center style="font-size:16px;color:#090909;font-family: MicrosoftYaHei;margin-bottom:20px;"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_parameter_settings")%></center>
	<form action="/system" id="system" >
		<input type="hidden" name="action" value="saveSystem">
<% if(!JDSMSServer.getInstance().getProperties().getString("settings.machine_model", "").equals("OXIO")) {%>
	<div class="sysset_main" >
			<div class="sysset_sub_title">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_parameter_settings_sub1")%>
					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="sysset_main_left">

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_device_status")%>
					</div>
					<div class="right_col morecheckbox2" >
						<label>
								<input type="checkbox"
									<%if ("yes".equals(request.getAttribute("device_using")))
							out.print("checked");%>
									name="device_using" id="device_using" value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_device")%>
						</label>
						<label>
									<input type="checkbox"
									<%if ("yes".equals(request.getAttribute("phone_using")))
							out.print("checked");%>
									name=phone_using id="phone_using" value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_phone")%>
						</label>
						<label>
									<input type="checkbox"
									<%if ("yes".equals(request.getAttribute("gateway_using")))
							out.print("checked");%>
									name="gateway_using" id="gateway_using" value=""
									onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_gateway")%>
						</label>

						<label>
								    <input type="checkbox"
									<%if ("yes".equals(request.getAttribute("lora_using")))
							out.print("checked");%>
									name="lora_using" id="lora_using" value=""
									onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_lora")%>
						</label>
						<label>
									<input type="checkbox"
									<%if ("yes".equals(request.getAttribute("nbiot_using")))
							out.print("checked");%>
									name="nbiot_using" id="nbiot_using" value=""
									onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_nbiot")%>
						</label>
						<label>
								    <input type="checkbox"
									<%if ("yes".equals(request.getAttribute("bd_using")))
							out.print("checked");%>
									name="bd_using" id="bd_using" value=""
									onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_send_by_bd")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>
				<!-- device options -->
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_sort")%>
					</div>
					<div class="right_col morecheckbox2" >
						<label>
								<input type="radio" name="using_sorted" id="using_sorted"
							value="0"
							<%if ("0".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_device_gateway_phone")%>
						</label>
						<label>
									<input type="radio" name="using_sorted" id="using_sorted"
							value="1"
							<%if ("1".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_device_phone_gateway")%>
						</label>
						<label>
									<input type="radio" name="using_sorted" id="using_sorted"
							value="2"
							<%if ("2".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_gateway_device_phone")%>
						</label>

						<label>
								    <input type="radio" name="using_sorted" id="using_sorted"
							value="3"
							<%if ("3".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_gateway_phone_device")%>
						</label>
						<label>
									<input type="radio" name="using_sorted" id="using_sorted"
							value="4"
							<%if ("4".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_phone_device_gateway")%>
						</label>
						<label>
								    <input type="radio" name="using_sorted" id="using_sorted"
							value="5"
							<%if ("5".equals(request.getAttribute("using_sorted")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_phone_gateway_device")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>


			<!-- left line block -->
			</div>
			<div class="sysset_main_right">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_log_level")%>
					</div>
					<div class="right_col morecheckbox" >
						<label>
								<input type="radio" name="log_level" id="log_level"
						value="DEBUG"
						<%if("DEBUG".equals(request.getAttribute("log_level")))out.print("checked"); %>>DEBUG
						</label>
						<label>
									<input type="radio" name="log_level" id="log_level" value="INFO"
															<%if("INFO".equals(request.getAttribute("log_level")))out.print("checked"); %>>INFO
						</label>
						<label>
									<input type="radio" name="log_level" id="log_level" value="WARN"
															<%if("WARN".equals(request.getAttribute("log_level")))out.print("checked"); %>>WARN
						</label>

						<label>
								    <input type="radio" name="log_level" id="log_level" value="ERROR"
								    						<%if("ERROR".equals(request.getAttribute("log_level")))out.print("checked"); %>>ERROR
						</label>
						<label>
									<input type="radio" name="log_level" id="log_level" value="FATAL"
															<%if("FATAL".equals(request.getAttribute("log_level")))out.print("checked"); %>>FATAL</td>
						</label>
					</div>
					<div class="clear"></div>
				</div>

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_suffix")%>
					</div>
					<div class="right_col">
						<input type="text" name="system_suffix" id="system_suffix"
							value="<%=request.getAttribute("system_suffix")%>">
					</div>
					<div class="clear"></div>
				</div>

			</div>
			<div class="clear"></div>
	</div>
<%}else{%>
	<div class="sysset_main" >
		<div class="sysset_sub_title">
			<div class="hang">
				<div class="left_col">
					<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_parameter_settings_sub1")%>
				</div>
				<div class="clear"></div>
			</div>
		</div>
		<div class="sysset_main_left">
			<div class="hang">
				<div class="left_col">
					<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
				.getString("settings.system_log_level")%>
				</div>
				<div class="right_col morecheckbox" >
					<label>
							<input type="radio" name="log_level" id="log_level"	value="DEBUG"
							<%if("DEBUG".equals(request.getAttribute("log_level")))out.print("checked"); %>>DEBUG
					</label>
					<label>
							<input type="radio" name="log_level" id="log_level" value="INFO"
							<%if("INFO".equals(request.getAttribute("log_level")))out.print("checked"); %>>INFO
					</label>
					<label>
							<input type="radio" name="log_level" id="log_level" value="WARN"
							<%if("WARN".equals(request.getAttribute("log_level")))out.print("checked"); %>>WARN
					</label>
					<label>
							<input type="radio" name="log_level" id="log_level" value="ERROR"
							<%if("ERROR".equals(request.getAttribute("log_level")))out.print("checked"); %>>ERROR
					</label>
					<label>
							<input type="radio" name="log_level" id="log_level" value="FATAL"
							<%if("FATAL".equals(request.getAttribute("log_level")))out.print("checked"); %>>FATAL</td>
					</label>
				</div>
			<div class="clear"></div>
			</div>
		</div>


		<!-- left line block -->
		<div class="sysset_main_right">
			<div class="hang">
				<div class="left_col">
					<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_suffix")%>
				</div>
				<div class="right_col">
					<input type="text" name="system_suffix" id="system_suffix"
						value="<%=request.getAttribute("system_suffix")%>">
				</div>
				<div class="clear"></div>
			</div>

		</div>
		<div class="clear"></div>
	</div>

	<!--一锟斤拷锟斤拷锟斤拷锟秸故撅拷锟叫╋拷锟斤拷锟?  -->

	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("device_using"))) out.print("checked");%>	name="device_using" id="device_using" value="" onclick="swi(this)">
	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("phone_using"))) out.print("checked");%>	name="phone_using" id="phone_using" value="" onclick="swi(this)">
	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("gateway_using"))) out.print("checked");%>	name="gateway_using" id="gateway_using" value="" onclick="swi(this)">
	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("lora_using"))) out.print("checked");%>	name="lora_using" id="lora_using" value="" onclick="swi(this)">
	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("nbiot_using"))) out.print("checked");%>	name="nbiot_using" id="nbiot_using" value="" onclick="swi(this)">
	<input type="checkbox" style="display:none;" <%if ("yes".equals(request.getAttribute("bd_using"))) out.print("checked");%>	name="bd_using" id="bd_using" value=""	onclick="swi(this)">

	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="0" <%if ("0".equals(request.getAttribute("using_sorted"))) out.print("checked");%> >
	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="1" <%if ("1".equals(request.getAttribute("using_sorted"))) out.print("checked");%> >
	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="2" <%if ("2".equals(request.getAttribute("using_sorted"))) out.print("checked");%> >
	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="3" <%if ("3".equals(request.getAttribute("using_sorted"))) out.print("checked");%> >
	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="4" <%if ("4".equals(request.getAttribute("using_sorted")))	out.print("checked");%> >
	<input type="radio" style="display:none;" name="using_sorted" id="using_sorted" value="5" <%if ("5".equals(request.getAttribute("using_sorted"))) out.print("checked");%> >


<%}%>
	<div style="height:15px;">&nbsp;</div>

	<div class="sysset_main" >
			<div class="sysset_sub_title">
				<div class="hang">
					<div class="left_col" style="width:300px;">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_parameter_settings_sub3")%>

					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="sysset_main_left">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_receive")%>
					</div>
					<div class="right_col">
						<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("delete_after_processing")))
							out.print("checked");%>
							name="delete_after_processing" id="delete_after_processing"
							value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						    .getString("settings.system_delete_sms_from_sim")%>
					</div>
					<div class="clear"></div>
				</div>
				<div class="hang" >
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_sendpriority")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="radio" name="sendfirst" id="sendfirst"
							value="1" <%if ("1".equals(request.getAttribute("sendfirst")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_sendfirst")%>
						</label>
						<label class="label2">
							<input type="radio" name="sendfirst" id="sendfirst"
							value="0" <%if ("0".equals(request.getAttribute("sendfirst")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_recvfirst")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_whether_register_gsm_network")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="radio" checked name="reg_gsm"
								id="reg_gsm" value="yes"
								<%if ("yes".equals(request.getAttribute("reg_gsm")))
						out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
							.getString("settings.system_register_gsm_network")%>
						</label>
						<label class="label2">
							<input type="radio" name="reg_gsm" id="reg_gsm" value="no"
								<%if ("no".equals(request.getAttribute("reg_gsm")))
						out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
							.getString("settings.system_not_register_gsm_network")%>
						</label>

					</div>
					<div class="clear"></div>
				</div>
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_working_mode")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="radio" checked name="send_mode"
							id="send_mode" value="sync"
							<%if ("sync".equals(request.getAttribute("send_mode")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_synchronous")%>
						</label>
						<label class="label2">
							<input type="radio" name="send_mode" id="send_mode" value="async"
							<%if ("async".equals(request.getAttribute("send_mode")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_asynchronous")%>
						</label>

					</div>
					<div class="clear"></div>
				</div>
				<div class="hang">
					<div class="left_col"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_ex_notify")%>
					</div>
					<div class="right_col">
						<label class="label3">
							<input type="radio" checked name="exnotify_mode" id="exnotify_mode" value="0" <%if (request.getAttribute("exnotify_mode")==null || "0".equals(request.getAttribute("exnotify_mode")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_ex_none")%>
						</label>
						<label class="label3">
							<input type="radio" name="exnotify_mode" id="exnotify_mode" value="1"<%if ("1".equals(request.getAttribute("exnotify_mode")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_ex_ring")%>
						</label>
            <label class="label2">
							<input type="radio" name="exnotify_mode" id="exnotify_mode" value="2"<%if ("2".equals(request.getAttribute("exnotify_mode")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_ex_voice")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>

			<!-- left line block -->
			</div>
			<div class="sysset_main_right">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_signature")%>
					</div>
					<div class="right_col">
						<input type="text" name="device_signature"
							id="device_signature"
							value="<%=request.getAttribute("device_signature")%>" placeholder="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_device_signature")%>">
					</div>
					<div class="clear"></div>
				</div>
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_inbound_interval")%>
					</div>
					<div class="right_col">
						<input type="text" name="inbound_interval"
						id="inbound_interval"
						value="<%=request.getAttribute("inbound_interval") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_second")%>
					</div>
					<div class="clear"></div>
				</div>

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_outbound_interval")%>
					</div>
					<div class="right_col">
						<input type="text" name="outbound_interval"
						id="outbound_interval"
						value="<%=request.getAttribute("outbound_interval") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_second")%>
					</div>
					<div class="clear"></div>
				</div>

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_device_send_speed")%>
					</div>
					<div class="right_col">
						<input type="text" name="send_speed" id="send_speed"
						value="<%=request.getAttribute("send_speed") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_pieces_hour")%>
					</div>
					<div class="clear"></div>
				</div>

				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_ex_ringlength")%>
					</div>
					<div class="right_col">
						<input type="text" name="ring_length" id="ring_length"
						value="<%=request.getAttribute("ring_length") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_second")%>
					</div>
					<div class="clear"></div>
				</div>

			</div>
			<div class="clear"></div>

	</div>
<% if(!JDSMSServer.getInstance().getProperties().getString("settings.machine_model", "").equals("OXIO")) {%>
	<div style="height:15px;">&nbsp;</div>
	<div class="sysset_main" >
			<div class="sysset_sub_title">
				<div class="hang">
					<div class="left_col title_sub">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_parameter_settings_sub2")%>
					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="sysset_main_left">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_outbound_interval4Gateway")%>
					</div>
					<div class="right_col">
						<input type="text" name="outbound_interval4Gateway"
						id="push_messages_interval"
						value="<%=request.getAttribute("outbound_interval4Gateway") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_second")%>
					</div>
					<div class="clear"></div>
				</div>

			<!-- left line block -->
			</div>
			<div class="sysset_main_right">
				<div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_gateway_signature")%>
					</div>
					<div class="right_col">
						<input type="text" name="signature" id="signature"
							value="<%=request.getAttribute("signature")%>" placeholder="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_gateway_signature")%>	">
					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="clear"></div>

	</div>

	<!-- three -->
	<div style="height:15px;">&nbsp;</div>
	<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_parameter_settings_sub4")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_app_per_sendcount")%>
						</div>
						<div class="right_col">
							<input name="app_send_count" id="app_send_count" value="<%=request.getAttribute("app_send_count") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_outbound_interval4Phone")%>
						</div>
						<div class="right_col">
							<input name="outbound_interval4Phone" id="outbound_interval" value="<%=request.getAttribute("outbound_interval4Phone") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang">
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_billing_cycle")%>
						</div>
						<div class="right_col" style="line-height:28px;padding:0px;height:28px; ">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_begin")%><select name="settlement_interval_day_begin"
													id="settlement_interval_day_begin">
														<option
															value="<%= request.getAttribute("settlement_interval_day_begin")%>"><%= request.getAttribute("settlement_interval_day_begin")%></option>
														<%
								for(int day = 1; day <= 31; day++){
							%>
														<option value="<%=day%>"><%=day%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_day")%> <select name="settlement_interval_hour_begin"
													id="settlement_interval_hour_begin">
														<option
															value="<%= request.getAttribute("settlement_interval_hour_begin")%>"><%= request.getAttribute("settlement_interval_hour_begin")%></option>
														<%
								for(int hour = 0; hour < 24; hour++){
							%>
														<option value="<%=hour%>"><%=hour%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_hour")%> <select name="settlement_interval_min_begin"
													id="settlement_interval_min_begin">
														<option
															value="<%= request.getAttribute("settlement_interval_min_begin")%>"><%= request.getAttribute("settlement_interval_min_begin")%></option>
														<%
								for(int min = 0; min < 60; min++){
							%>
														<option value="<%=min%>"><%=min%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_min")%><select name="settlement_interval_second_begin"
													id="settlement_interval_second_begin">
														<option
															value="<%= request.getAttribute("settlement_interval_second_begin")%>"><%= request.getAttribute("settlement_interval_second_begin")%></option>
														<%
								for(int second = 0; second < 60; second++){
							%>
														<option value="<%=second%>"><%=second%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_sec")%>
							<div style="height:10px;"></div>


						</div>
						<div class="clear"></div>
					</div>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_phone_overtime")%>
						</div>
						<div class="right_col">
							<input name="phone_overtime" id="phone_overtime" value="<%=request.getAttribute("phone_overtime") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_max_count_msgs_send_by_phone")%>
						</div>
						<div class="right_col">
							<input name="phone_msg_max_count" id="phone_msg_max_count" value="<%=request.getAttribute("phone_msg_max_count") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_piece")%>
						</div>
						<div class="clear"></div>
						<div class="hang" style="float:left !important;line-height:28px;padding:0px;height:28px;margin-top:5px;margin-left:0px; ">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_end")%><select name="settlement_interval_day_end"
													id="settlement_interval_day_end">
														<option
															value="<%= request.getAttribute("settlement_interval_day_end")%>"><%= request.getAttribute("settlement_interval_day_end")%></option>
														<%
								for(int day = 1; day <= 31; day++){
							%>
														<option value="<%=day%>"><%=day%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_day")%> <select name="settlement_interval_hour_end"
													id="settlement_interval_hour_end">
														<option
															value="<%= request.getAttribute("settlement_interval_hour_end")%>"><%= request.getAttribute("settlement_interval_hour_end")%></option>
														<%
								for(int hour = 0; hour < 24; hour++){
							%>
														<option value="<%=hour%>"><%=hour%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_hour")%> <select name="settlement_interval_min_end"
													id="settlement_interval_min_end">
														<option
															value="<%= request.getAttribute("settlement_interval_min_end")%>"><%= request.getAttribute("settlement_interval_min_end")%></option>
														<%
								for(int min = 0; min < 60; min++){
							%>
														<option value="<%=min%>"><%=min%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_min")%> <select name="settlement_interval_second_end"
													id="settlement_interval_second_end">
														<option
															value="<%= request.getAttribute("settlement_interval_second_end")%>"><%= request.getAttribute("settlement_interval_second_end")%></option>
														<%
								for(int second = 0; second < 60; second++){
							%>
														<option value="<%=second%>"><%=second%></option>
														<%} %>
												</select> <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_sec")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="clear"></div>
		</div>
<%}else{%>
	<input  style="display:none;" type="text" name="outbound_interval4Gateway"	id="outbound_interval4Gateway"	value="<%=request.getAttribute("outbound_interval4Gateway") %>">
	<input  style="display:none;" type="text" name="signature" id="signature"	value="<%=request.getAttribute("signature")%>" >
	<input  style="display:none;" name="app_send_count" id="app_send_count" value="<%=request.getAttribute("app_send_count") %>" type="text">
	<input  style="display:none;" name="outbound_interval4Phone" id="outbound_interval" value="<%=request.getAttribute("outbound_interval4Phone") %>" type="text">
	<select style="display:none;" name="settlement_interval_day_begin" id="settlement_interval_day_begin">
		<option	value="<%= request.getAttribute("settlement_interval_day_begin")%>"><%= request.getAttribute("settlement_interval_day_begin")%></option>
		<% for(int day = 1; day <= 31; day++){ %><option value="<%=day%>"><%=day%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_hour_begin" id="settlement_interval_hour_begin">
		<option	value="<%= request.getAttribute("settlement_interval_hour_begin")%>"><%= request.getAttribute("settlement_interval_hour_begin")%></option>
		<% for(int hour = 0; hour < 24; hour++){ %><option value="<%=hour%>"><%=hour%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_min_begin" id="settlement_interval_min_begin">
		<option value="<%= request.getAttribute("settlement_interval_min_begin")%>"><%= request.getAttribute("settlement_interval_min_begin")%></option>
		<% for(int min = 0; min < 60; min++){ %><option value="<%=min%>"><%=min%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_second_begin"	id="settlement_interval_second_begin">
	<option	value="<%= request.getAttribute("settlement_interval_second_begin")%>"><%= request.getAttribute("settlement_interval_second_begin")%></option>
		<% for(int second = 0; second < 60; second++){	%><option value="<%=second%>"><%=second%></option><%} %>
	</select>
	<input style="display:none;" name="phone_overtime" id="phone_overtime" value="<%=request.getAttribute("phone_overtime") %>" type="text">
	<input style="display:none;" name="phone_msg_max_count" id="phone_msg_max_count" value="<%=request.getAttribute("phone_msg_max_count") %>" type="text">
	<select style="display:none;" name="settlement_interval_day_end"	id="settlement_interval_day_end">
		<option	value="<%= request.getAttribute("settlement_interval_day_end")%>"><%= request.getAttribute("settlement_interval_day_end")%></option>
		<% 	for(int day = 1; day <= 31; day++){	%><option value="<%=day%>"><%=day%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_hour_end"	id="settlement_interval_hour_end">
		<option value="<%= request.getAttribute("settlement_interval_hour_end")%>"><%= request.getAttribute("settlement_interval_hour_end")%></option>
		<% for(int hour = 0; hour < 24; hour++){ %><option value="<%=hour%>"><%=hour%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_min_end" id="settlement_interval_min_end">
		<option value="<%= request.getAttribute("settlement_interval_min_end")%>"><%= request.getAttribute("settlement_interval_min_end")%></option>
		<% for(int min = 0; min < 60; min++){ %><option value="<%=min%>"><%=min%></option><%} %>
	</select>
	<select style="display:none;" name="settlement_interval_second_end" id="settlement_interval_second_end">
		<option value="<%= request.getAttribute("settlement_interval_second_end")%>"><%= request.getAttribute("settlement_interval_second_end")%></option>
		<% for(int second = 0; second < 60; second++){ %><option value="<%=second%>"><%=second%></option><%} %>
	</select>
<%}%>
	<div style="height:15px;">&nbsp;</div>
	<div class="sysset_main" >
			<div class="sysset_sub_title">
				<div class="hang">
					<div class="left_col title_sub">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_parameter_settings_sub6")%>
					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="sysset_main_left">
				<div class="hang" >
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_get_tel_from_mail")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="checkbox"
						<%if ("yes".equals(request.getAttribute("get_from_title")))
				out.print("checked");%>
						name="get_from_title" id="get_from_title" value=""
						onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_get_tel_from_head")%>
						</label>
						<label class="label2" style="margin-bottom:10px;">
							<input type="checkbox"
						<%if ("yes".equals(request.getAttribute("get_from_content")))
				out.print("checked");%>
						name="get_from_content" id="get_from_content" value=""
						onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_get_tel_from_content")%>
						</label>
						<br>
						<label>
							<input type="checkbox"
						<%if ("yes".equals(request.getAttribute("get_from_conf")))
				out.print("checked");%>
						name="get_from_conf" id="get_from_conf" value="<%=request.getAttribute("get_from_conf")%>"
						onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_get_tel_from_user")%>
					<input type="text" name="recipients" maxlength="128"
						id="recipients"
						value="<%=request.getAttribute("recipients")%>"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
					.getString("settings.system_recipients")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>

			<!-- left line block -->
			</div>
			<div class="sysset_main_right">
				<div class="hang" >
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_get_content_from_mail1")%>
						<br>
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_get_content_from_mail2")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("get_content_from_mail_title")))
					out.print("checked");%>
							name="get_content_from_mail_title" id="get_content_from_mail_title" value=""
							onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_get_content_from_mail_title")%>
						</label>
						<label class="label2">
							<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("get_content_from_mail_content")))
					out.print("checked");%>
							name="get_content_from_mail_content" id="get_content_from_mail_content" value=""
							onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						.getString("settings.system_get_content_from_mail_content")%>
						</label>
					</div>
					<div class="clear"></div>
				</div>
			</div>
			<div class="clear"></div>

	</div>
	<div class="form_btn">
		<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
		<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
	</div>

	</form>

	<div style="height:15px;">&nbsp;</div>

	<!-- two block -->
	<form action="/system" id="httpserver">
		<input type="hidden" name="action" value="saveHttpServer">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_receive_interface")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_port")%>
						</div>
						<div class="right_col">
							<input name="port" id="port" value="<%=request.getAttribute("port") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang">
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_protocol_type")%>
						</div>
						<div class="right_col">
							<label>
							<input type="checkbox"
								<%if ("yes".equals(request.getAttribute("use_ssl"))) out.print("checked");%>
									name="use_ssl" id="use_ssl" value="<%=request.getAttribute("use_ssl")%>" onclick="swi(this)">
									<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
										.getString("settings.system_use_ssl")%>
							</label>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_send_psw")%>
						</div>
						<div class="right_col">
							<input name="password_send" id="password_send" value="<%=request.getAttribute("password_send") %>" type="password">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_receive_psw")%>
						</div>
						<div class="right_col">
							<input name="password_read" id="password_read" value="<%=request.getAttribute("password_read") %>" type="password">
						</div>
						<div class="clear"></div>
					</div>
					<%
						String sendURL = (String)request.getAttribute("sendURL");
						String readURL = (String)request.getAttribute("readURL");
						String queryURL = (String)request.getAttribute("queryURL");
						//
						String send_api_protocol=("yes".equals(request.getAttribute("use_ssl")))?"https":"http";
						String send_api_URL=send_api_protocol+"://"+request.getLocalAddr()+":"+request.getAttribute("port")+"/send?password="+request.getAttribute("password_send")+"&recipient=10086&text=ceshi&encoding=U";
						// ifstart
						if(sendURL!=null||readURL!=null){
					%>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_httpserver_apitest")%>
						</div>
						<div class="right_col">
							<a class='api_href' target="_blank" href="send.html" style="color:darkcyan;"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_httpserver_apiclick")%></a>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang">
					<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_httpserver_api_download")%>
						</div>
						<div class="right_col">
							<a class='api_href' target="_blank" href="./doc/JDSMSApiDoc.pdf" style="color:darkcyan;"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_httpserver_api_doc")%></a>

						</div>
						<div class="clear"></div>
					</div>


				<!-- left line block -->
				</div>
				<div class="sysset_main_right">

					<div class="hang">
						<%
							if(sendURL!=null)
								out.println(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_send_url")+"<BR>"+send_api_protocol+"://"+sendURL+"&encoding=U"+"  <BR>");
							if(readURL!=null)
								out.println("<div class='line_u'></div>");
								out.println(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_receive_url")+"<BR>"+send_api_protocol+"://"+readURL+"  <BR>");
							if(queryURL!=null)
								out.println("<div class='line_u'></div>");
								out.println(ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_query_url")+"<BR>"+send_api_protocol+"://"+queryURL+"  <BR>");
						%>

						<div class="clear"></div>
					</div>
					<div class="hang">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_httpserver_api_example")%>:<br><a class='api_href' target="_blank" href="<%=send_api_URL%>" style="color:darkcyan;"><%=send_api_URL%></a>
					</div>
					<!-- ifend -->
					<%} %>
				</div>
				<div class="clear"></div>

		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>

	<div style="height:15px;">&nbsp;</div>

  <form action="" id="mailboxSetting">
    <input type="hidden" name="action" value="saveMailbox">
    <div class="sysset_main">
      <div class="sysset_sub_title">
        <div class="hang">
          <div class="left_col title_sub">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
                      .getString("settings.mail_interface_title")%>
          </div>
          <div class="clear"></div>
        </div>
      </div>
      <div class="sysset_main_left">
        <div class="hang">
          <div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_enabled_state")%>
					</div>
					<div class="right_col">
						<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("monmail_enable")))
							  out.print("checked");%>
                name="monmail_enable" id="monmail_enable"
                value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						    .getString("settings.mail_interface_enable")%>
					</div>
					<div class="clear"></div>
        </div>

				<div class="hang">
					<div class="left_col"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_type")%>
					</div>
					<div class="right_col">
						<label class="label3">
							<input type="radio" checked name="monmail_mailbox_protocol" id="monmail_mailbox_protocol" value="pop3" <%if (request.getAttribute("monmail_mailbox_protocol")==null || "pop3".equals(request.getAttribute("monmail_mailbox_protocol")))
					out.print("checked");%>>pop3
						</label>
						<label class="label3">
							<input type="radio" name="monmail_mailbox_protocol" id="monmail_mailbox_protocol" value="pop3s"<%if ("pop3s".equals(request.getAttribute("monmail_mailbox_protocol")))
					out.print("checked");%>>pop3s
						</label>
            <label class="label3">
							<input type="radio" name="monmail_mailbox_protocol" id="monmail_mailbox_protocol" value="imap"<%if ("imap".equals(request.getAttribute("monmail_mailbox_protocol")))
					out.print("checked");%>>imap
						</label>
            <label class="label3">
							<input type="radio" name="monmail_mailbox_protocol" id="monmail_mailbox_protocol" value="imaps"<%if ("imaps".equals(request.getAttribute("monmail_mailbox_protocol")))
					out.print("checked");%>>imaps
						</label>
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_inbox")%>
					</div>
					<div class="right_col">
						<input type="text" name="monmail_mailbox_name"
							id="monmail_mailbox_name"
							value="<%=request.getAttribute("monmail_mailbox_name")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col"></div>
          <div class="right_col"></div>
          <div class="clear"></div>
				</div>

      </div>
      <div class="sysset_main_right">

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_address")%>
					</div>
					<div class="right_col">
						<input type="text" name="monmail_mailbox_host"
							id="monmail_mailbox_host"
							value="<%=request.getAttribute("monmail_mailbox_host")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_port")%>
					</div>
					<div class="right_col">
						<input type="text" name="monmail_mailbox_port"
							id="monmail_mailbox_port"
							value="<%=request.getAttribute("monmail_mailbox_port")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_user")%>
					</div>
					<div class="right_col">
						<input type="text" name="monmail_mailbox_user"
							id="monmail_mailbox_user"
							value="<%=request.getAttribute("monmail_mailbox_user")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_recv_pwd")%>
					</div>
					<div class="right_col">
						<input type="password" name="monmail_mailbox_password"
							id="monmail_mailbox_password"
							value="<%=request.getAttribute("monmail_mailbox_password")%>">
					</div>
					<div class="clear"></div>
				</div>

      </div>

      <div class="clear"></div>

    </div>

    <div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
    </div>
  </form>

	<div style="height:15px;">&nbsp;</div>


  <form action="" id="mailSendSetting">
    <input type="hidden" name="action" value="saveSendMail">
    <div class="sysset_main">
      <div class="sysset_sub_title">
        <div class="hang">
          <div class="left_col title_sub">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
                      .getString("settings.mail_send_title")%>
          </div>
          <div class="clear"></div>
        </div>
      </div>
      <div class="sysset_main_left">
        <div class="hang">
          <div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.phone_enabled_state")%>
					</div>
					<div class="right_col">
						<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("monsend_enable")))
							  out.print("checked");%>
                name="monsend_enable" id="monsend_enable"
                value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						    .getString("settings.mail_send_enable")%>
					</div>
					<div class="clear"></div>
        </div>

				<div class="hang">
					<div class="left_col"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_send_secure")%>
					</div>
					<div class="right_col">
						<label class="label2">
							<input type="radio" checked name="monsend_secure" id="monsend_secure" value="normal" <%if (request.getAttribute("monsend_secure")==null || "normal".equals(request.getAttribute("monsend_secure")))
					out.print("checked");%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_ex_none")%>
						</label>
						<label class="label2">
							<input type="radio" name="monsend_secure" id="monsend_secure" value="ssl"<%if ("ssl".equals(request.getAttribute("monsend_secure")))
					out.print("checked");%>>SSL
						</label>
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col"></div>
          <div class="right_col"></div>
          <div class="clear"></div>
				</div>
        <div class="hang">
					<div class="left_col"></div>
          <div class="right_col"></div>
          <div class="clear"></div>
				</div>

      </div>
      <div class="sysset_main_right">

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_send_address")%>
					</div>
					<div class="right_col">
						<input type="text" name="monsend_mailbox_host"
							id="monsend_mailbox_host"
							value="<%=request.getAttribute("monsend_mailbox_host")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_send_port")%>
					</div>
					<div class="right_col">
						<input type="text" name="monsend_mailbox_port"
							id="monsend_mailbox_port"
							value="<%=request.getAttribute("monsend_mailbox_port")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_send_user")%>
					</div>
					<div class="right_col">
						<input type="text" name="monsend_mailbox_user"
							id="monsend_mailbox_user"
							value="<%=request.getAttribute("monsend_mailbox_user")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.mail_send_pwd")%>
					</div>
					<div class="right_col">
						<input type="password" name="monsend_mailbox_password"
							id="monsend_mailbox_password"
							value="<%=request.getAttribute("monsend_mailbox_password")%>">
					</div>
					<div class="clear"></div>
				</div>

      </div>

      <div class="clear"></div>

    </div>

    <div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
    </div>
  </form>

	<div style="height:15px;">&nbsp;</div>

	<form action="" id="callbackSetting" >
    <input type="hidden" name="action" value="saveMonback">
		<div class="sysset_main" >

      <div class="sysset_sub_title">
        <div class="hang">
          <div class="left_col title_sub">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_parameter_settings_sub5")%>
          </div>
          <div class="clear"></div>
        </div>
      </div>

      <div class="sysset_main_left">
        <div class="hang">
          <div class="left_col">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_call_back_status")%>
          </div>
          <div class="right_col">
            <input type="checkbox"
              <%if ("yes".equals(request.getAttribute("monback_enable")))
                out.print("checked");%>
                name="monback_enable" id="monback_enable"
                value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
                .getString("settings.system_call_back_switch")%>
          </div>
          <div class="clear"></div>
        </div>
        <div class="hang">
          <div class="left_col">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_protocol_type")%>
          </div>
          <div class="right_col">
            <label class="label3">
              <input type="radio" name="monback_method" id="monback_method" value="GET" <%if (request.getAttribute("monback_method")==null || !"POST".equals(request.getAttribute("monback_method")))
                        out.print("checked");%>>GET
            </label>
            <label class="label3">
              <input type="radio" name="monback_method" id="monback_method" value="POST" <%if ("POST".equals(request.getAttribute("monback_method")))
                        out.print("checked");%>>POST
            </label>
          </div>
          <div class="clear"></div>
        </div>
        <div class="hang">
          <div class="left_col">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_call_back_url")%>
          </div>
          <div class="right_col">
          </div>
          <div class="clear"></div>
        </div>
      </div>

      <div class="sysset_main_right">
        <div class="hang">
          <div class="left_col">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_call_back_interval")%>
          </div>
          <div class="right_col">
            <input type="text" name="call_back_interval" id="call_back_interval"
            value="<%=JDSMSServer.getInstance().getProperties().getString("settings.push_messages_interval","") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_second")%>
          </div>
          <div class="clear"></div>
        </div>
        <div class="hang">
          <div class="left_col">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_call_back_interval_day")%>
          </div>
          <div class="right_col">
            <input type="text" name="call_back_interval_day" id="call_back_interval_day"
            value="<%=JDSMSServer.getInstance().getProperties().getString("settings.push_fail_interval","") %>">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
            .getString("settings.system_day")%>
          </div>
          <div class="clear"></div>
        </div>
      </div>

      <div class="hang">
        <input type="text" name="monback_geturl" id="monback_geturl" class='callbackUrlTextLine' value="<%=request.getAttribute("monback_geturl")%>">
        <br>
        <a id="callbackTestBtn" href="javascipt:void();" onclick="callbackTester()" style="color:darkcyan;width:177px;"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
          .getString("settings.system_call_back_test_link")%>
        </a>
        <div class="clear"></div>
      </div>

		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>

	</form>

	<div style="height:15px;">&nbsp;</div>


  <form action="" id="wechatSetting">
    <input type="hidden" name="action" value="saveWechat">
    <div class="sysset_main">
      <div class="sysset_sub_title">
        <div class="hang">
          <div class="left_col title_sub">
            <%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
                      .getString("settings.wechat_interface_title")%>
          </div>
          <div class="clear"></div>
        </div>
      </div>
      <div class="sysset_main_left">
        <div class="hang">
          <div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_enable_status")%>
					</div>
					<div class="right_col">
						<input type="checkbox"
							<%if ("yes".equals(request.getAttribute("monwechat_enable")))
							  out.print("checked");%>
                name="monwechat_enable" id="monwechat_enable"
                value="" onclick="swi(this)"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
						    .getString("settings.wechat_interface_enable")%>
					</div>
					<div class="clear"></div>
        </div>

				<div class="hang">
					<div class="left_col"><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_match_phone")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_match_phone"
							id="monwechat_match_phone"
							value="<%=request.getAttribute("monwechat_match_phone")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_match_content")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_match_content"
							id="monwechat_match_content"
							value="<%=request.getAttribute("monwechat_match_content")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_template")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_template"
							id="monwechat_template"
							value="<%=request.getAttribute("monwechat_template")%>">
					</div>
					<div class="clear"></div>
				</div>

      </div>
      <div class="sysset_main_right">

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_match_token")%>
					</div>
					<div class="right_col">
						<input type="password" name="monwechat_token"
							id="monwechat_token"
							value="<%=request.getAttribute("monwechat_token")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_to_wxid")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_towxid"
							id="monwechat_towxid"
							value="<%=request.getAttribute("monwechat_towxid")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_match_time_start")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_time_start"
							id="monwechat_time_start"
							value="<%=request.getAttribute("monwechat_time_start")%>">
					</div>
					<div class="clear"></div>
				</div>

        <div class="hang">
					<div class="left_col">
						<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.wechat_match_time_end")%>
					</div>
					<div class="right_col">
						<input type="text" name="monwechat_time_end"
							id="monwechat_time_end"
							value="<%=request.getAttribute("monwechat_time_end")%>">
					</div>
					<div class="clear"></div>
				</div>

      </div>

      <div class="clear"></div>

    </div>

    <div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
    </div>
  </form>



	<div style="height:15px;">&nbsp;</div>

	<% if(!JDSMSServer.getInstance().getProperties().getString("settings.machine_model", "").equals("OXIO")) {%>

	<!-- three block -->
	<form action="/system" id="nbiotSetting">
		<input type="hidden" name="action" value="saveNbIoTSettings">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_server")%>
						</div>
						<div class="right_col">
							<input name="mqttServer" id="mqttServer" value="<%=request.getAttribute("mqttServer") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_port")%>
						</div>
						<div class="right_col">
							<input name="mqttPort" id="mqttPort" value="<%=request.getAttribute("mqttPort") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_user")%>
						</div>
						<div class="right_col">
							<input name="mqttUser" id="mqttUser" value="<%=request.getAttribute("mqttUser") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_password")%>
						</div>
						<div class="right_col">
							<input name="mqttPassword" id="mqttPassword" value="<%=request.getAttribute("mqttPassword") %>" type="password">
						</div>
						<div class="clear"></div>
					</div>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<div class="hang">
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
							.getString("settings.system_device_status")%>
						</div>

						<div class="right_col" id="autoWidth">
							<label>
									<input type="radio" name="mqttQOS" id="mqttQOS" value=0
											    <%if ((Integer)request.getAttribute("mqttQOS")==0){
											    	out.print("checked");
											    }%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
													        .getString("settings.system_mqtt_qos_0")%>
							</label>
							<label>
										<input type="radio" name="mqttQOS" id="mqttQOS" value=1
													<%if ((Integer)request.getAttribute("mqttQOS")==1){
														out.print("checked");
													}%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												     	        .getString("settings.system_mqtt_qos_1")%>
							</label>
							<label>
										<input type="radio" name="mqttQOS" id="mqttQOS" value=2
													<%if ((Integer)request.getAttribute("mqttQOS")==2){
														out.print("checked");
													}%>><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
														        .getString("settings.system_mqtt_qos_2")%>
							</label>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_outbound_slip_interval")%>
						</div>
						<div class="right_col">
							<input name="mqttOSI" id="mqttOSI" value="<%=request.getAttribute("mqttOSI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_outbound_interval")%>
						</div>
						<div class="right_col">
							<input name="mqttOI" id="mqttOI" value="<%=request.getAttribute("mqttOI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_mqtt_inbound_interval")%>
						</div>
						<div class="right_col">
							<input name="mqttII" id="mqttII" value="<%=request.getAttribute("mqttII") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="clear"></div>

		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>


	<form action="/system" id="loraSetting">
		<input type="hidden" name="action" value="saveLoRaSettings">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_lora")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_lora_secret_key")%>
						</div>
						<div class="right_col">
							<input name="loraSecretKey" id="loraSecretKey" value="<%=request.getAttribute("loraSecretKey") %>">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_lora_outbound_slip_interval")%>
						</div>
						<div class="right_col">
							<input name="loraOSI" id="loraOSI" value="<%=request.getAttribute("loraOSI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_lora_outbound_interval")%>
						</div>
						<div class="right_col">
							<input name="loraOI" id="loraOI" value="<%=request.getAttribute("loraOI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_lora_inbound_interval")%>
						</div>
						<div class="right_col">
							<input name="loraII" id="loraII" value="<%=request.getAttribute("loraII") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="clear"></div>
		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>

	<form action="/system" id="bdSetting">
		<input type="hidden" name="action" value="saveBDSettings">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_bd")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_bd_send_times")%>
						</div>
						<div class="right_col">
							<input name="bdSTS" id="bdSTS" value="<%=request.getAttribute("bdSTS") %>" type="text">
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_bd_outbound_slip_interval")%>
						</div>
						<div class="right_col">
							<input name="bdOSI" id="bdOSI" value="<%=request.getAttribute("bdOSI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_bd_outbound_interval")%>
						</div>
						<div class="right_col">
							<input name="bdOI" id="bdOI" value="<%=request.getAttribute("bdOI") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
					<div class="hang" >
						<div class="left_col">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_bd_inbound_interval")%>
						</div>
						<div class="right_col">
							<input name="bdII" id="bdII" value="<%=request.getAttribute("bdII") %>" type="text">&nbsp;<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
												.getString("settings.system_second")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="clear"></div>

		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>
	<% } %>

	<!-- hidden form -->
	<% if(!JDSMSServer.getInstance().isWindows() &&
		JDSMSServer.getInstance().getProperties().getString("settings.machine_model", "").equals("AIO")) {%>
	<form action="/system" id="ipSetting" name="ipSetting">
		<input type="hidden" name="action" value="saveIpSetting">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_aio_tcp_ip_setting")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<fieldset id="ipfield" disabled style="border:0;">
			        	<legend>
			        		<input type="radio" name="chooseip" id="followedip" <%if("static".equals(request.getAttribute("autoIp")))out.print("checked"); %>
			        		value="1" onclick="chooseIpOpt(this)" style="display:none;"  />
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
							.getString("settings.system_use_this_ip")%>
						</legend>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_ip")%>
							</div>
							<div class="right_col">
								<input name="ipAddr" id="ipAddr" value="<%=request.getAttribute("ipAddr") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_subnet_mask")%>
							</div>
							<div class="right_col">
								<input name="subnet_mask" id="subnet_mask" value="<%=request.getAttribute("subnet_mask") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_default_gateway")%>
							</div>
							<div class="right_col">
								<input name="default_gateway" id="default_gateway" value="<%=request.getAttribute("default_gateway") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>

    				</fieldset>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<fieldset id="dnsfield" disabled style="border:0;">
				        <legend>
				        	<input type="radio" name="chooseDNS" id="followedDNS" <%if("static".equals(request.getAttribute("autoIp")))out.print("checked"); %>
				        		value="3" onclick="chooseIpOpt(this)" style="display:none;" /><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault)
								.getString("settings.system_use_this_dns")%>
				        </legend>
				        <div class="hang" >
				        	<div class="left_col">
				        		<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_first_dns")%>
				        	</div>
				        	<div class="right_col">
				        		<input name="preferred_dns" id="preferred_dns" value="<%=request.getAttribute("preferred_dns") %>" type="text">
				        	</div>
				        	<div class="clear"></div>
				        </div>
				        <div class="hang" >
				        	<div class="left_col">
				        		<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_second_dns")%>
				        	</div>
				        	<div class="right_col">
				        		<input name="alternate_dns" id="alternate_dns" value="<%=request.getAttribute("alternate_dns") %>" type="text">
				        	</div>
				        	<div class="clear"></div>
				        </div>
			    	</fieldset>
				</div>
				<div class="clear"></div>
		</div>

		<div class="form_btn">
			<input type="submit" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>" onClick="saveIPConfig();">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>
	<div style="height:15px;">&nbsp;</div>
	<% } %>



	<!-- hidden form -->
	<% if(!JDSMSServer.getInstance().isWindows() &&
		JDSMSServer.getInstance().getProperties().getString("settings.machine_model", "").equals("LINUX")) {%>
	<form action="/system" id="sysInfoIpSetting" name="sysInfoIpSetting">
		<input type="hidden" name="action" value="saveSysInfoSetting">
		<div class="sysset_main" >
				<div class="sysset_sub_title">
					<div class="hang">
						<div class="left_col title_sub">
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_linux_tcp_ip_setting")%>
						</div>
						<div class="clear"></div>
					</div>
				</div>
				<div class="sysset_main_left">
					<fieldset id="my_ip_field" disabled style="border:0;">
			      <legend>
              <input type="radio" name="sys_info_choose_ip" id="my_choose_ip" <%if(((Integer)request.getAttribute("sys_info_ip_type"))==2)out.print("checked"); %>
			        		   value="11" style="display:none;"  />
							<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_use_this_ip")%>
						</legend>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_ip")%>
							</div>
							<div class="right_col">
								<input name="sys_info_ip_address" id="sys_info_ip_address" value="<%=request.getAttribute("sys_info_ip_address") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_subnet_mask")%>
							</div>
							<div class="right_col">
								<input name="sys_info_ip_netmask" id="sys_info_ip_netmask" value="<%=request.getAttribute("sys_info_ip_netmask") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>
						<div class="hang" >
							<div class="left_col">
								<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_default_gateway")%>
							</div>
							<div class="right_col">
								<input name="sys_info_ip_gateway" id="sys_info_ip_gateway" value="<%=request.getAttribute("sys_info_ip_gateway") %>" type="text">
							</div>
							<div class="clear"></div>
						</div>

    				</fieldset>

				<!-- left line block -->
				</div>
				<div class="sysset_main_right">
					<fieldset id="my_dns_field" disabled style="border:0;">
				        <legend>
				        	<input type="radio" name="sys_info_choose_dns" id="my_choose_dns" <%if(((Integer)request.getAttribute("sys_info_dns_type"))==2)out.print("checked"); %>
				        		value="12" style="display:none;" /><%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_use_this_dns")%>
				        </legend>
				        <div class="hang" >
				        	<div class="left_col">
				        		<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_first_dns")%>
				        	</div>
				        	<div class="right_col">
				        		<input name="sys_info_dns_address1" id="sys_info_dns_address1" value="<%=request.getAttribute("sys_info_dns_address1") %>" type="text">
				        	</div>
				        	<div class="clear"></div>
				        </div>
				        <div class="hang" >
				        	<div class="left_col">
				        		<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_second_dns")%>
				        	</div>
				        	<div class="right_col">
				        		<input name="sys_info_dns_address2" id="sys_info_dns_address2" value="<%=request.getAttribute("sys_info_dns_address2") %>" type="text">
				        	</div>
				        	<div class="clear"></div>
				        </div>
			    	</fieldset>
				</div>
				<div class="clear"></div>
		</div>

		<div class="form_btn" <%if(((Integer)request.getAttribute("sys_info_ip_type"))!=2) out.print("style=\"display:none;\""); %>>
			<input type="button" class="submit_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_save")%>" onClick="saveSysInfoIPConfig();">
			<input type="reset" class="reset_btn" value="<%=ResourceManager.getInstance().getBykey(ResourceManager.getInstance().m_sDefault).getString("settings.system_reset")%>">
		</div>
	</form>
	<div style="height:15px;">&nbsp;</div>
	<% } %>


<%if(request.getAttribute("message")!=null){ %>
<script type="text/javascript">
alert('<%=request.getAttribute("message")%>');
</script>

<% } %>
</div>
</body>
</html>